#include <Wire.h>
#include "ThingSpeak.h"
#include "MAX30100_PulseOximeter.h"
#include <ESP8266WiFi.h>
#define sig D3
#define ind D5
#define temp A0
int sos =108;
char ssid[] = "POCO X2";
char pass[] = "23456789";
#define REPORTING_PERIOD_MS     3000
PulseOximeter pox;
uint32_t tsLastReport = 0;
void onBeatDetected()
{
    ;
}
WiFiClient  client;
unsigned long myChannelNumber = 1692760;
const char * myWriteAPIKey = "BRPZTFXC51XRL9D0"; 

void setup()
{
    Serial.begin(115200);
    pinMode(sig,INPUT);
    pinMode(D4,OUTPUT);
    
    Serial.print("Initializing pulse oximeter..");
    if (!pox.begin()) {
        Serial.println("FAILED");
        for(;;);
    } else {
        Serial.println("SUCCESS");
        digitalWrite(1,HIGH);
    }
     pox.setIRLedCurrent(MAX30100_LED_CURR_24MA);
    pox.setOnBeatDetectedCallback(onBeatDetected);
     WiFi.mode(WIFI_STA);
     ThingSpeak.begin(client);
     if (WiFi.status() != WL_CONNECTED)
  {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    while (WiFi.status() != WL_CONNECTED)
    {
      WiFi.begin(ssid, pass);
      Serial.print(".");
      delay(5000);
    }
    Serial.println("\nConnected.");
  }
}
 
void loop()
{
  digitalWrite(D5,HIGH);
  digitalWrite(D4,HIGH);
  analogRead(temp);
pox.update();
    if (millis() - tsLastReport > REPORTING_PERIOD_MS) {
        Serial.print("BPM: ");
        int pulse = pox.getHeartRate();
        Serial.print(pulse);
        Serial.print("    SpO2: ");
        int spo2 = pox.getSpO2();
        Serial.print(spo2);
        Serial.print("%");
        Serial.println("\n");
        tsLastReport = millis();
        ThingSpeak.writeField(myChannelNumber,1,temp,myWriteAPIKey);
        ThingSpeak.writeField(myChannelNumber,2,pulse,myWriteAPIKey);
        ThingSpeak.writeField(myChannelNumber,3,spo2,myWriteAPIKey);
    }
if(digitalRead(sig) == HIGH){ 
ThingSpeak.writeField(myChannelNumber,1,sos, myWriteAPIKey);
}
}
